/* ============ */
/* setgap.c	*/
/* ============ */
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include <miscdefs.h>
#include <gapdefs.h>
#include <math.h>
#include <maxgapln.c>
#define	ACT(X)	#X

#define	CLAMP(Var, Lo, Hi)	__min(Hi, __max(Lo, Var))

#define	NEED_MIN_CELL_EXPECT(LO, HI) \
	"Enter Minimum Cell Expectation ["ACT(LO)"-"ACT(HI)"]: "

#define	NEED_NUMBER_GAPS(LO, HI) \
	"Enter Number of Gaps to be Tabulated ["\
		ACT(LO)"-"ACT(HI)"]: "

#define	REPORT_USER_DBL_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL);printf("\n");			\
	printf("\tNumber Entered:  %.6f", Entry);	\
	printf(" (%s)\n", Label);			\
    }
#define	REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL);printf("\n");			\
	printf("\tNumber Entered:  %.f", (double)Entry);\
	printf(" (%s)\n", Label);			\
    }
#define	SHOW_DBL_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.6f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

static	double	CellExpect[MAX_GAP_LEN+1];
static	double	GapProbs[MAX_GAP_LEN+1];
/* ==================================================================== */
/*  SetGapControls - Puts Run Controls in GapData structure	*/
/* ==================================================================== */
void
SetGapControls(GAP_DATA_STRU *GapData)
{
    int     k, MaxGapLen, NewlineCh, WhereMin;
    long    MinGapCt;
    char    Prompt[64];

    double  UserDblEntry;
    int     UserIntEntry;
    long    UserLongEntry;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    /* -------------------------------------------- */
    /* Request Lower Boundary of Gap, L: 0 <= L < 1 */
    /* -------------------------------------------- */
    GetDbl("Enter Lower Boundary (L) of Gap [0 <= L < 1]: ",
	&UserDblEntry);

    REPORT_USER_DBL_ENTRY(UserDblEntry, "Lower Boundary of Gap");

    GapData->GapLoLimit =
	CLAMP(UserDblEntry, 0.0,
	    ((double)RAND_MAX-1)/((double)RAND_MAX+1));

    SHOW_DBL_VALUE_USED(UserDblEntry, GapData->GapLoLimit);

    GapData->LoGapInt = (UINT)
	ceil(GapData->GapLoLimit * ((double)RAND_MAX+1));

    /* -------------------------------------------- */
    /* Request Upper Boundary of Gap, U: L < U <= 1 */
    /* -------------------------------------------- */
    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    sprintf(Prompt,
	"Enter Upper Boundary (U) of Gap [%f < U <= 1]: ",
	GapData->GapLoLimit);

    GetDbl(Prompt, &UserDblEntry);

    REPORT_USER_DBL_ENTRY(UserDblEntry, "Upper Boundary of Gap");

    GapData->GapHiLimit =
	CLAMP(UserDblEntry, GapData->GapLoLimit, 1.0);

    SHOW_DBL_VALUE_USED(UserDblEntry, GapData->GapHiLimit);

    GapData->HiGapInt = (UINT)
	ceil(GapData->GapHiLimit * ((double)RAND_MAX+1));

    P(printf("Integer Value of Lower Boundary: %u\n"
	     "Integer Value of Upper Boundary: %u\n",
		GapData->LoGapInt, GapData->HiGapInt));

    if (GapData->HiGapInt - GapData->LoGapInt > RAND_MAX)
    {
	fflush(NULL); fprintf(stderr, "%c", NewlineCh);
	fprintf(stderr,
	    "You Have Specified Gap Limits 0 and 1. "
	    "Please Reenter.\n");
	exit(1);
    }

    if (GapData->HiGapInt <= GapData->LoGapInt+163)
    {
	fflush(NULL); fprintf(stderr, "%c", NewlineCh);
	fprintf(stderr,
	    "The Difference Between the Lower Boundary (%.15g)\nand the"
	    " Upper Boundary (%.15g) is not Great Enough (%.8g)\n"
	    "You should specify limits that differ by .005 or more.\n",
		GapData->GapLoLimit, GapData->GapHiLimit,
		GapData->GapHiLimit - GapData->GapLoLimit);
	exit(1);
    }

    WhereMin = GetMaxGapLen(GapData->GapLoLimit, GapData->GapHiLimit,
	MIN_CELL_XPCT, MAX_NUM_GAPS, MAX_GAP_LEN, GapProbs, &MinGapCt);

    P(printf("WhereMin = %d, MinGapCt = %d\n", WhereMin, MinGapCt));
    /* ---------------------------------------- */
    /* Request Maximum Gap Length to be Tallied */
    /* ---------------------------------------- */
    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    MaxGapLen = (WhereMin-1 > MIN_GAP_LEN) ? WhereMin-1 : MIN_GAP_LEN;
    sprintf(Prompt, "Enter Maximum Gap Length [%d-%d]: ", MIN_GAP_LEN,
	MaxGapLen);

    GetInt(Prompt, &UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, "Maximum Gap Length");

    GapData->MaxGapLen =
	CLAMP(UserIntEntry, MIN_GAP_LEN, MaxGapLen);

    SHOW_INT_VALUE_USED(UserIntEntry, GapData->MaxGapLen);

    /* -------------------------------------- */
    /* Calculate & Store Number of Categories */
    /* -------------------------------------- */
    GapData->NumCategories = GapData->MaxGapLen + 1;

    /* -------------------------------- */
    /* Request Minimum Cell Expectation	*/
    /* -------------------------------- */
    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    GetInt(NEED_MIN_CELL_EXPECT(MIN_CELL_XPCT, MAX_CELL_XPCT),
	&UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, "Minimum Cell Expectation");

    /* ---------------- */
    /* Clamp CellExpect */
    /* ---------------- */
    GapData->UserCellExpect =
	__min(MAX_CELL_XPCT, __max(MIN_CELL_XPCT, UserIntEntry));

    SHOW_INT_VALUE_USED(UserIntEntry, GapData->UserCellExpect);

    /* -------------------------------------------------------- */
    /* Calculate Probabilities Based on Data Width & Gap Length */
    /* Recall That NumCategories = MaxGapLen + 1		*/
    /* -------------------------------------------------------- */
    CalcGapProbs(GapData->NumCategories,
		 GapData->GapLoLimit,
		 GapData->GapHiLimit,
		 GapProbs);

    /* ------------------------------------------------------------- */
    /* Compute Number Gaps Needed to Deliver User's Cell Expectation */
    /*    and  Number Gaps Needed to Deliver Minimum Expectation.    */
    /* ------------------------------------------------------------- */
    GapData->UserNumGaps  = -1;
    GapData->IdealNumGaps = -1;

    for (k = 0; k < GapData->NumCategories; ++k)
    {
	long	NextGap;

	if (GapProbs[k] == 0)
	{
	    continue;
	}
	NextGap = (long)
	    (floor(0.5 + GapData->UserCellExpect/GapProbs[k]));
	GapData->UserNumGaps = __max(NextGap, GapData->UserNumGaps);

	NextGap = (long)
	    floor(0.5 + MIN_CELL_XPCT/GapProbs[k]);

	GapData->IdealNumGaps = __max(NextGap, GapData->IdealNumGaps);
    }

    /* ------------------------------------------------- */
    /* Get User-Specified Number of Gaps to Be Tabulated */
    /* ------------------------------------------------- */
    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    sprintf(Prompt, "How Many Gaps Are To Be Tabulated?"
    		    "  [%ld ...]: ", GapData->UserNumGaps);

    GetLong(Prompt, &UserLongEntry);

    REPORT_USER_INT_ENTRY(UserLongEntry, "Number of Gaps to be Tabulated");

    GapData->NumGaps = (UserLongEntry > GapData->UserNumGaps) ?
			UserLongEntry : GapData->UserNumGaps;

    SHOW_INT_VALUE_USED(UserLongEntry, GapData->NumGaps);

    /* -------------------------------------------------- */
    /* Calculate Cell Expectations Based on Probabilities */
    /* -------------------------------------------------- */
    for (k = 0; k < GapData->NumCategories; ++k)
    {
	CellExpect[k] = GapProbs[k] * GapData->NumGaps;
	P(printf("GapProbs[%2d] = %f, CellExpect[%2d] = %17.11f\n",
		k, GapProbs[k], k, CellExpect[k]));
    }

    /* -------------------------------------------------- */
    /* Lump lower-valued categories into next higher ones */
    /* -------------------------------------------------- */
    GapData->NotEnough = 0;
    for (k = 0; k < GapData->NumCategories - 1; ++k)
    {
	double  NextInt = floor(0.5 + CellExpect[k]);
	if (NextInt < GapData->UserCellExpect)
	{
	    ++GapData->NotEnough;
# if 0
	    CellExpect[k+1] += CellExpect[k];
	    CellExpect[k]    = 0;
# endif
	}
    }
   GapData->CellExpect = CellExpect;

    /* ------------------------------ */
    /* Set Generator Failure Count to */
    /* A Priori Mean + 100 * Std Dev. */
    /* ------------------------------ */
    {
	double	GapMean, GapStdDev;

	CalcGapMeanStdDev(1,
	    GapData->GapHiLimit - GapData->GapLoLimit,
	    &GapMean, &GapStdDev);

	GapData->MaxGenPerGap = (long)
	    (ceil(GapMean) +
	    100 * ceil(GapStdDev));
    }
    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    printf("\nFailure Count = %ld\n", GapData->MaxGenPerGap);
    printf("\tA Complete Gap Should Have Been\n"
	   "\tTabulated Within This Many Variates.\n");
    P(printf("NotEnough = %d\n", GapData->NotEnough));

    GapData->CallStatusOK = (GapData->NotEnough == 0);
}
